local data = SkillTreeTweakData.init

function SkillTreeTweakData:init(tweak_data)
    data(self, tweak_data)

    local pc1 = 200
    local pc3 = 400
    local pc5 = 1000
    local pc7 = 2400
    local pc9 = 4000

    table.insert(self.specializations, {
        name_id = "gamblerv2'name", -- Deck name
        desc_id = "gamblerv2'desc", -- Deck description

        { -- Perk 1, gives the player 200% damage and 50% chance
            upgrades = {
                "player_damage_multiplier_one",
                "pk_all_or_nothing"
            },
            cost = pc1,
            icon_xy = {0, 0},
            texture_bundle_folder = "cflapflapgamble",
            name_id = "gamblerv2'perk1n",
            desc_id = "gamblerv2'perk1d"
        },
        { -- Perk 2
            upgrades = {
                "weapon_passive_headshot_damage_multiplier"
            },
            cost = 300,
            icon_xy = {1, 0},
            name_id = "all_2",
            desc_id = "all_2_desc"
        },
        { -- Perk 3, once fire good then weapon damage plus 200%
            upgrades = {
                "pk_gamblers_rush"
            },
            cost = pc3,
            icon_xy = {1, 0},
            texture_bundle_folder = "cflapflapgamble",
            name_id = "gamblerv2'perk3n",
            desc_id = "gamblerv2'perk3d"
        },
        { -- Perk 4
            upgrades = {
                "passive_player_xp_multiplier",
                "player_passive_suspicion_bonus",
                "player_passive_armor_movement_penalty_multiplier"
            },
            cost = 600,
            icon_xy = {3, 0},
            name_id = "all_4",
            desc_id = "all_4_desc"
        },
        { -- Perk 5, adds 20 dodge
            upgrades = {
                "player_tier_dodge_chance_1"
            },
            cost = pc5,
            icon_xy = {2, 0},
            texture_bundle_folder = "cflapflapgamble",
            name_id = "gamblerv2'perk5n",
            desc_id = "gamblerv2'perk5d"
        },
        { -- Perk 6
            upgrades = {
                "armor_kit",
                "player_pick_up_ammo_multiplier"
            },
            cost = 1600,
            icon_xy = {5, 0},
            name_id = "all_6",
            desc_id = "all_6_desc"
        },
        { -- Perk 7, 80/20 chance thingy
            upgrades = {
                "pk_winning_streak"
            },
            cost = pc7,
            icon_xy = {3, 0},
            texture_bundle_folder = "cflapflapgamble",
            name_id = "gamblerv2'perk7n",
            desc_id = "gamblerv2'perk7d"
        },
        { -- Perk 8
            upgrades = {
                "weapon_passive_damage_multiplier",
                "passive_doctor_bag_interaction_speed_multiplier"
            },
            cost = 3200,
            icon_xy = {7, 0},
            name_id = "all_8",
            desc_id = "all_8_desc"
        },
        { -- Perk 9, lifesteal gambling
            upgrades = {
                "pk_lifesteal"
            },
            cost = pc9,
            icon_xy = {0, 1},
            texture_bundle_folder = "cflapflapgamble",
            name_id = "gamblerv2'perk9n",
            desc_id = "gamblerv2'perk9d"
        }
    })
end